package kom.itbeankit.common.itbeanframe;

/*************************************************************************************
 * ItBeanFrame is a Frame which contains
 * several components to visualize, control and parametrize an ItBean. Of course,
 * ItBeanFrame is a bean itself, so you can use it to visualize your ItBean.
 * Communication in parent direction is made by java.awt.event.WindowEvents,
 * ItBeanControlEvents and ItBeanMenuEvents.
 * @author: Abdulmotaleb El Saddik, Christian C. Hoffmann
 * @version 0.5  26.06.1998
 *
 * <code>
 * Table of modifications
 * <table>
 * <tr>
 * <td>07.05.1998  <td>  Abdulmotaleb El Saddik  <td>  first Release
 * </tr> <tr>
 * <td>26.06.1998   <td> Christian C. Hoffmann  <td>
 *                                         inner class ItBeanFrameItemAdapter added<br>
 *                                         following methods added:<br>
 *                                         explanationChanged(), languageChanged(),<br>
 *                                         levelChanged(), itBeanNew_Action(),<br>
 *                                         itBeanSave_Action(), itBeanSaveAs_Action(),<br>
 *                                         fireFrameEvent(), addItBeanFrameListener(),<br>
 *                                         removeItBeanFrameListener(), getTopLeftPanel(),<br>
 *                                         getBottomRightPanel(), appendText(),<br>
 *                                         getEnteredURL(), setEnteredULR()<br>
 * </tr><tr>
 * <td>08.07.1998   <td>Alexander Kempf    <td>   VCRTimer implemented <BR>
 * <td>13.07.1998  <td> Abdulmotaleb El Saddik  <td>  more text
 * <td>03.08.1998  <td> Abdulmotaleb El Saddik  <td>  Internationalization, supported
 languages are: English, German, Spanish
 * <td>05.08.1998  <td> Abdulmotaleb El Saddik  <td>  getStepDelayTime(), setStepDelayTime()
 * </tr> </table>
 * </code>
 */

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.net.*;

import kom.itbeankit.common.vcr.*;
import symantec.itools.awt.*;

import kom.itbeankit.common.vcr.ControlButtonPanel;
import symantec.itools.awt.SplitterPanel;
import kom.itbeankit.nw.ethernet.Host;
import kom.itbeankit.common.message.Messenger;
import kom.itbeankit.nw.ethernet.Ethernet;
public class ItBeanFrame extends Frame
{
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	//{{DECLARE_CONTROLS
	kom.itbeankit.common.vcr.ControlButtonPanel vcr;
	java.awt.Panel panel;
	java.awt.Panel mainPanel;
	java.awt.Panel parameterPanel;
	java.awt.Panel textPanel;
	//}}
	private String defaultDir;
	private String aboutMessage;
	private URL enteredURL;
	private ItBeanFrameListener listener;
	//kom.itbeankit.common.vcr.ControlButtonPanel vcrControlButtonPanel1;

	//{{DECLARE_MENUS
	java.awt.MenuBar mainMenuBar;
	java.awt.Menu FileMenu;
	java.awt.MenuItem itBeanNew;
	java.awt.MenuItem itBeanOpen;
	java.awt.MenuItem itBeanSave;
	java.awt.MenuItem itBeanSaveAs;
	java.awt.MenuItem itBeanExit;
	java.awt.Menu OptionsMenu;
	java.awt.Menu languageMenu;
	java.awt.CheckboxMenuItem language1MenuItem;
	java.awt.CheckboxMenuItem language2MenuItem;
	java.awt.CheckboxMenuItem language3MenuItem;
	java.awt.Menu ExplanationMenu;
	java.awt.CheckboxMenuItem checkboxMenuItem1;
	java.awt.CheckboxMenuItem checkboxMenuItem2;
	java.awt.CheckboxMenuItem checkboxMenuItem3;
	java.awt.Menu helpMenu;
	java.awt.MenuItem itBeanGuidedTour;
	java.awt.MenuItem itBeanAbout;
	//}}
    public CheckboxMenuItemGroup languages;
	SplitterPanel splitterPanel1;
    
    
	public ItBeanFrame()
	{
	    super();
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setVisible(false);
		setSize(618,460);
		setFont(new Font("Dialog", Font.PLAIN, 12));
		setForeground(new Color(0));
		setBackground(new Color(16777215));
		vcr = new kom.itbeankit.common.vcr.ControlButtonPanel();
		vcr.setTimerDelay(50);
		vcr.setLayout(new GridLayout(1,1,0,0));
		vcr.setBounds(0,437,618,23);
		add("South", vcr);
		panel = new java.awt.Panel();
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		panel.setLayout(gridBagLayout);
		panel.setBounds(0,0,618,437);
		add("Center", panel);
		mainPanel = new java.awt.Panel();
		mainPanel.setLayout(new BorderLayout(0,0));
		mainPanel.setBounds(0,0,618,330);
		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(mainPanel, gbc);
		panel.add(mainPanel);
		mainPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
		parameterPanel = new java.awt.Panel();
		gridBagLayout = new GridBagLayout();
		parameterPanel.setLayout(gridBagLayout);
		parameterPanel.setBounds(529,330,89,107);
		parameterPanel.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(parameterPanel, gbc);
		panel.add(parameterPanel);
		parameterPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
		textPanel = new java.awt.Panel();
		textPanel.setLayout(new BorderLayout(0,0));
		textPanel.setBounds(0,330,529,107);
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(textPanel, gbc);
		panel.add(textPanel);
		setTitle("ItBean Frame");
		//}}
    	//p.add(getControlButtonPanel1(), getControlButtonPanel1().getName());

		//{{INIT_MENUS
		mainMenuBar = new java.awt.MenuBar();
		FileMenu = new java.awt.Menu("  File  ");
		itBeanNew = new java.awt.MenuItem("New");
		FileMenu.add(itBeanNew);
		itBeanOpen = new java.awt.MenuItem("Open");
		FileMenu.add(itBeanOpen);
		itBeanSave = new java.awt.MenuItem("Save");
		FileMenu.add(itBeanSave);
		itBeanSaveAs = new java.awt.MenuItem("Save as ...");
		FileMenu.add(itBeanSaveAs);
		FileMenu.addSeparator();
		itBeanExit = new java.awt.MenuItem("Exit");
		FileMenu.add(itBeanExit);
		mainMenuBar.add(FileMenu);
		OptionsMenu = new java.awt.Menu("  Options  ");
		languageMenu = new java.awt.Menu("Languages");
		language1MenuItem = new java.awt.CheckboxMenuItem("Englisch");
		language1MenuItem.setState(false);
		languageMenu.add(language1MenuItem);
		language2MenuItem = new java.awt.CheckboxMenuItem("Deutsch");
		language2MenuItem.setState(false);
		languageMenu.add(language2MenuItem);
		language3MenuItem = new java.awt.CheckboxMenuItem("Spanisch");
		language3MenuItem.setState(false);
		languageMenu.add(language3MenuItem);
		OptionsMenu.add(languageMenu);
		ExplanationMenu = new java.awt.Menu("Explanation");
		checkboxMenuItem1 = new java.awt.CheckboxMenuItem("Log");
		checkboxMenuItem1.setState(true);
		ExplanationMenu.add(checkboxMenuItem1);
		checkboxMenuItem2 = new java.awt.CheckboxMenuItem("Errors");
		checkboxMenuItem2.setState(false);
		ExplanationMenu.add(checkboxMenuItem2);
		checkboxMenuItem3 = new java.awt.CheckboxMenuItem("Debug");
		checkboxMenuItem3.setState(false);
		ExplanationMenu.add(checkboxMenuItem3);
		OptionsMenu.add(ExplanationMenu);
		mainMenuBar.add(OptionsMenu);
		helpMenu = new java.awt.Menu("  Help  ");
		itBeanGuidedTour = new java.awt.MenuItem("Guided Tour");
		helpMenu.add(itBeanGuidedTour);
		itBeanAbout = new java.awt.MenuItem("About");
		helpMenu.add(itBeanAbout);
		mainMenuBar.add(helpMenu);
		setMenuBar(mainMenuBar);
		//$$ mainMenuBar.move(0,0);
		//}} INIT_MENUS
        
        this.languages = new CheckboxMenuItemGroup();
        languages.add(language1MenuItem);
       	languages.add(language2MenuItem);
       	languages.add(language3MenuItem);
	
	    //remove(panel);
	
		splitterPanel1 = new symantec.itools.awt.SplitterPanel();
		splitterPanel1.setBounds(0,0,640,417);
		add("Center",splitterPanel1);	
	
		splitterPanel1.setGapSizes(9); 
		splitterPanel1.split(splitterPanel1.SPLIT_HORIZONTAL);
        splitterPanel1.getBottomPanel().split(splitterPanel1.SPLIT_VERTICAL);
        splitterPanel1.getBottomRightPanel().setLayout(new BorderLayout(0,0));
        splitterPanel1.getBottomRightPanel().add("Center",parameterPanel);
        splitterPanel1.getTopPanel().setLayout(new BorderLayout(0,0));
        splitterPanel1.getTopPanel().add("Center",mainPanel);
        splitterPanel1.getBottomLeftPanel().setLayout(new BorderLayout(0,0));
        splitterPanel1.getBottomLeftPanel().add("Center",messenger);
	    remove(panel);
        //itBeanTextArea.setBounds(splitterPanel1.getBottomLeftPanel().getBounds());
        /*vcrControlButtonPanel1 = new kom.itbeankit.common.vcr.ControlButtonPanel();
		vcrControlButtonPanel1.setLayout(gridBagLayout);
		vcrControlButtonPanel1.setBounds(0,0,468,188);
		p2.add("Center", vcrControlButtonPanel1);*/

		//{{REGISTER_LISTENERS USING ANONYMUS INNER CLASS
		ItBeanWindowAdapter anitBeanWindowAdapter = new ItBeanWindowAdapter();
		addWindowListener(anitBeanWindowAdapter);
		ItBeanFrameAction litBeanFrameAction = new ItBeanFrameAction();
		this.itBeanOpen.addActionListener(litBeanFrameAction);
		this.itBeanAbout.addActionListener(litBeanFrameAction);
		this.itBeanSave.addActionListener(litBeanFrameAction);
		this.itBeanSaveAs.addActionListener(litBeanFrameAction);
		this.itBeanExit.addActionListener(litBeanFrameAction);
		this.itBeanGuidedTour.addActionListener(litBeanFrameAction);
		this.itBeanNew.addActionListener(litBeanFrameAction);
		this.vcr.addActionListener(litBeanFrameAction);
        ItBeanFrameItemAdapter itemAdapter = new ItBeanFrameItemAdapter();
		this.language1MenuItem.addItemListener(itemAdapter);
		this.language2MenuItem.addItemListener(itemAdapter);
		this.language3MenuItem.addItemListener(itemAdapter);
		this.checkboxMenuItem1.addItemListener(itemAdapter);
		this.checkboxMenuItem2.addItemListener(itemAdapter);
		this.checkboxMenuItem3.addItemListener(itemAdapter);
		//}}
	}

    public void paint(Graphics g){
        super.paint(g);
        messenger.setBounds(splitterPanel1.getBottomLeftPanel().getBounds());
        parameterPanel.setBounds(0,0,
                            splitterPanel1.getBottomRightPanel().getSize().width,
                            splitterPanel1.getBottomRightPanel().getSize().height);
    }

	public ItBeanFrame(String title)
	{
		this();
		setTitle(title);
	}

    /**
    This method sets the complexitylevel
    */
    public void setNumberOfLevels(int numberoflevels) {
    this.vcr.setNumberOfComplexityLevels(numberoflevels);
    }


    /**
    This method gets the complexitylevel
    */
    public int getNumberOfLevels() {
        return this.vcr.getNumberOfComplexityLevels();
    }

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}
		super.setVisible(b);
	}
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();

		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(insets().left, insets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}

    /*********************************************************************************
   * Called whenever the part throws an exception.
   * @param exception java.lang.Throwable
   ********************************************************************************/
  private void handleException(Throwable exception) {
    /* Uncomment the following lines to print uncaught exceptions to stdout */
    System.out.println("UNCAUGHT EXCEPTION in ItBeanFrame");
    exception.printStackTrace(System.out);
  }

  /**
   * Return the ControlButtonPanel1 property value.
   * @return common.itbeanframe.ControlButtonPanel
   */
  private ControlButtonPanel getControlButtonPanel1() {
    if (vcr == null) {
      try {
	    vcr = new ControlButtonPanel();
	    vcr.setName("ControlButtonPanel1");
	    vcr.setBounds(20, 375, 355, 35);
      } catch (java.lang.Throwable e) {
	    handleException(e);
      };
    }
    return vcr;
  }

 // Methods to get/set the DelayTime of a vcrControlButtonPanel event
    public int getStepDelayTime() {
        return vcr.getTimerDelay();
    }

    public void setStepDelayTime(int newDelayTime) {
        vcr.setTimerDelay(newDelayTime);
    }

   /**
	Inner class itBeanWindowAdapter implements the WindowEvent action.
	*/
	class ItBeanWindowAdapter extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == ItBeanFrame.this)
				ItBeanFrame_hide();
		}
	}

	void ItBeanFrame_hide()
	{
		setVisible(false);	// hide the Frame
	}

	class ItBeanFrameAction implements java.awt.event.ActionListener
	{
		/* This method receives the ActionEvents */
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == itBeanNew)
			    itBeanNew_Action(event);
			else if (object == itBeanOpen)
				itBeanOpen_Action(event);
			else if (object == itBeanAbout)
				itBeanAbout_Action(event);
			else if (object == itBeanExit)
				itBeanExit_Action(event);
			else if (object == itBeanSave)
			    itBeanSave_Action(event);
			else if (object == itBeanSaveAs)
			    itBeanSaveAs_Action(event);
			else if (object == itBeanGuidedTour)
			    itBeanGuidedTour_Action(event);
		  //new line added by Alexander Kempf888
			else if (object == vcr)
			    vcrControlButtonPanel1_Action(event);
		}
	}


	/**
	This inner class implements the ItemListener that listens on changed menu items.
	*/
	class ItBeanFrameItemAdapter implements java.awt.event.ItemListener {

    /**
    Will be called if a CheckboxMenuItem was changed.
	@param the occurred itemEvent
	*/
	public void itemStateChanged(java.awt.event.ItemEvent e) {
	  Object source = e.getSource();
	    if ((source == checkboxMenuItem1) || (source == checkboxMenuItem2) || (source == checkboxMenuItem3))
	      explanationChanged(e);
	    if ((source == language1MenuItem) || (source == language2MenuItem) || (source == language3MenuItem))
	      languageChanged(e);
	    }
	}

	/** Called if the explanation was changed in options menu */
	void explanationChanged(ItemEvent e) {
	    CheckboxMenuItem source = (CheckboxMenuItem)e.getSource();
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.EXPLANATION_CHANGED, source.getActionCommand()));
	}

	/** Called if the language was changed in options menu */
	void languageChanged(ItemEvent e) {
	  CheckboxMenuItem source = (CheckboxMenuItem)e.getSource();
      fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.LANGUAGE_CHANGED, source.getActionCommand() ));
    }

	/** Called if the new item was selected. Forwards the event. */
	void itBeanNew_Action(ActionEvent event) {
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.NEW_FILE));
	}

	/** Called if the save item was selected. SAVE the event. */
	void itBeanSave_Action(java.awt.event.ActionEvent event) {
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.SAVE));
	}

	/** Called if the save_as item was selected. Opens a file dialog and
	forwards the event if a valid file was choiced. */
	void itBeanSaveAs_Action(java.awt.event.ActionEvent event) {
        FileDialog dialog = new FileDialog(this, "Save As", FileDialog.SAVE);
        if (this.defaultDir != null) dialog.setDirectory(this.defaultDir);
        dialog.show();
		// now FileDialog returned
		if (dialog.getFile() == null) return;
		this.defaultDir = dialog.getDirectory();
		fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.SAVE_AS, dialog.getDirectory()+dialog.getFile()));
	}

	/** Called if the about item was selected. Opens the about dialog and forwards the event. */
	void itBeanAbout_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from About Create and show as modal
		AboutDialog ad = new AboutDialog(this, true);
		//ad.setUserLabel(this.aboutMessage);
		ad.setVisible(true);
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.ABOUT));
		//}}
	}

	/** Called if the GuidedTour item was selected. Forwards the event. */
	void itBeanGuidedTour_Action(ActionEvent event) {
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.GUIDED_TOUR));
	}

	/** Called if the exit item was selected. A Yes/No-dialog will be opened
	and the event will be forwarded if the dialog returns true. */
	void itBeanExit_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from Exit Create and show as modal
	fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.EXIT));
		//}}
	}

	/** Called if the open_URL item was selected. A URLDialog will be opened.
	If it returns a valid URL, an ItBeanFrameEvent.OPEN event will be fired */
	void itBeanOpen_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from Open... Show the URLDialog
		URLDialog dialog = new URLDialog(this, "Enter URL");
		if (this.enteredURL != null ) dialog.setURL(this.enteredURL);
		dialog.setSize(300,200);
		dialog.show();
		if (dialog.getURL() != null) { // if a valid URL has been entered
		    this.enteredURL = dialog.getURL();
		    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.OPEN_URL));
		}
		//}}
	}

	/**
	This method is invoked if the vcrControlButtonPanel1 sources an ActionEvent.
	It invokes the fireFrameEvent()-method with a newly created ItBeanFramEvent.
	This method was added by Alexander Kempf
	*/

	void vcrControlButtonPanel1_Action(java.awt.event.ActionEvent event) {
	    if ("play".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.PLAY,event.getActionCommand()));
	    else if ("stop".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.STOP,event.getActionCommand()));
	    else if ("forwards".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.FORWARDS,event.getActionCommand()));
	    else if ("backwards".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.BACKWARDS,event.getActionCommand()));
	    else if ("pause".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.PAUSE,event.getActionCommand()));
	    else if ("hide".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.HIDE,event.getActionCommand()));
        else if ("levelDown".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.LEVEL_DOWN,event.getActionCommand()));
        else if ("levelUp".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.LEVEL_UP,event.getActionCommand()));

	}

	/**
	This method fires an ItBeanFrameEvent by calling the methods of the
	registrated ItBeanFrameListeners.
	*/
	private void fireFrameEvent(ItBeanFrameEvent e) {
	    if (this.listener == null) return;
	    int id = e.getID();
	    switch (id) {
	        case ItBeanFrameEvent.NEW_FILE: { this.listener.newFile(e); break; }
        	case ItBeanFrameEvent.STOP: { this.listener.stop(e); break; }
        	case ItBeanFrameEvent.PLAY: { this.listener.play(e); break; }
        	case ItBeanFrameEvent.PAUSE: { this.listener.pause(e); break; }
        	case ItBeanFrameEvent.FORWARDS: { this.listener.forwards(e); break; }
           	case ItBeanFrameEvent.TOBEGIN: { this.listener.toBegin(e); break; }
	        case ItBeanFrameEvent.BACKWARDS: { this.listener.backwards(e); break; }
	        case ItBeanFrameEvent.HIDE: { this.listener.hide(e); break; }
	        case ItBeanFrameEvent.OPEN_URL: { this.listener.openURL(e); break; }
	        case ItBeanFrameEvent.SAVE: { this.listener.save(e); break; }
	        case ItBeanFrameEvent.SAVE_AS: { this.listener.saveAs(e); break; }
	        case ItBeanFrameEvent.EXIT: { this.listener.exit(e); break; }
	        case ItBeanFrameEvent.LEVEL_DOWN: { this.listener.levelDown(e); break; }
	        case ItBeanFrameEvent.LEVEL_UP: { this.listener.levelUp(e); break; }
	        case ItBeanFrameEvent.LANGUAGE_CHANGED: { this.listener.languageChanged(e); break; }
            case ItBeanFrameEvent.EXPLANATION_CHANGED: { this.listener.explanationChanged(e); break; }
	        case ItBeanFrameEvent.GUIDED_TOUR: { this.listener.guidedTour(e); break; }
            case ItBeanFrameEvent.ABOUT: { this.listener.about(e); break; }
        }
    }

    /**
    This method is used to registrate the ItBeanFrameListener.
    Only one listener is allowed (unicast).
    @param the listener
    @exception java.util.TooManyListenersException
    */
    public synchronized void addItBeanFrameListener(ItBeanFrameListener l) throws java.util.TooManyListenersException{
        if ((this.listener != null) && (this.listener != l)) {
            throw new java.util.TooManyListenersException("Already a listener registrated");
        }
        if (l != null) this.listener = l;
    }

    /**
    This method is used to deregistrate the ItBeanFrameListener.
    @param the listener
    */
    public synchronized void removeItBeanFrameListener(ItBeanFrameListener l) {
        if (this.listener == l) this.listener = null;
    }

    /**
    This method returns the top subpanel, which is normally
    used to visualize the itBeans information (visualization output).
    @return the top  panel
    */
    public Component getTopComponent() {
    Component p = (Component) this.splitterPanel1.getTopPanel();
    //p.setSize(300,300);
    return p;
    }

    public void setTopComponent(Component c) {
    //c.setSize(300,300);
     splitterPanel1.getTopPanel().add(c);
    }

    /**
    This method returns the bottom right subpanel, which is normally
    used to place some components to parametrize the bean (e.g. Choices, Checkboxes)
    @return the bottom right panel
    */
    public Component getBottomRightComponent() {
      return (Component)this.splitterPanel1.getBottomRightPanel();
    }

    public void setBottomRightComponent(Component c) {
      splitterPanel1.getBottomRightPanel().add(c);
    }

    /**
    This method returns the bottom left subpanel, which is normally
    used to place some components to parametrize the bean (e.g. Choices, Checkboxes)
    @return the bottom right panel
    */
    public Component getBottomLeftComponent() {
      return (Component)this.splitterPanel1.getBottomRightPanel();
    }

    public void setBottomLeftComponent(Component c) {
      splitterPanel1.getBottomRightPanel().add(c);
    }


    /**
    This method appends text to the text area at top right, which
    is normally used to print log, help and explanation texts.
    @param the text to append
    */
    public void appendText(String text) {
      this.messenger.append(text);
    }

    /**
    This method returns the URL if an URL was entered after having
    selected the openURL menu item.
    @return the entered URL
    */
    public URL getEnteredURL() {
        return this.enteredURL;
    }

    /**
    This method sets the URL that is default if an URLDialog is opened.
    Normally the parent applet sets the CodeBase- or the DocumentBase-URL.
    @param the default URL
    */
    public void setEnteredULR(URL defaultURL) {
        this.enteredURL = defaultURL;
    }

    /**
    This method sets the default directory for the file dialog of the SaveAs-menu-item.
    @param the default directory
    */
    public void setDefaultDir(String dir) {
        this.defaultDir = dir;
    }

    /**
    This method sets the bean specified about-message that is printed out in the
    AboutDialog after heving selected about item.
    @param the about message
    */
    public void setAboutMessage(String message) {
        this.aboutMessage = message;
    }


	static public void main(String args[])
	{
		(new ItBeanFrame()).setVisible(true);
	}
	
    




}
